<?php

return [
    /*
    |--------------------------------------------------------------------------
    | BayarCash Portal Key
    |--------------------------------------------------------------------------
    |
    | Your BayarCash portal key for identifying your merchant account.
    |
    */
    'portal_key' => env('BAYARCASH_PORTAL_KEY'),

    /*
    |--------------------------------------------------------------------------
    | BayarCash Personal Access Token (PAT)
    |--------------------------------------------------------------------------
    |
    | Your BayarCash Personal Access Token for API authentication.
    | This is a long token (~988 characters).
    |
    */
    'pat' => env('BAYARCASH_PAT'),

    /*
    |--------------------------------------------------------------------------
    | BayarCash Secret Key
    |--------------------------------------------------------------------------
    |
    | Your BayarCash secret key used for checksum generation and webhook
    | verification. This ensures the integrity and authenticity of callbacks.
    |
    */
    'secret_key' => env('BAYARCASH_SECRET_KEY'),

    /*
    |--------------------------------------------------------------------------
    | BayarCash Mode
    |--------------------------------------------------------------------------
    |
    | Environment mode: 'sandbox' for testing or 'production' for live payments.
    |
    */
    'mode' => env('BAYARCASH_MODE', 'sandbox'),

    /*
    |--------------------------------------------------------------------------
    | BayarCash API Version
    |--------------------------------------------------------------------------
    |
    | API version to use. v3 supports webhook callbacks via POST requests.
    | Webhook URL: POST to {callback_url} with transaction status updates.
    |
    */
    'api_version' => env('BAYARCASH_API_VERSION', 'v3'),
];
