@echo off
REM GengSewa Production Cleanup Script (Windows)
REM Removes unnecessary files and optimizes for production deployment

echo ======================================
echo GengSewa Production Cleanup Script
echo ======================================
echo.

REM 1. Remove development dependencies
echo [1/8] Removing development dependencies...
set /p confirm1="Remove composer development dependencies? (y/n): "
if /i "%confirm1%"=="y" (
    composer install --no-dev --optimize-autoloader
    echo Done: Development dependencies removed
)

REM 2. Remove documentation files
echo.
echo [2/8] Cleaning up documentation files...
set /p confirm2="Remove old/redundant documentation files? (y/n): "
if /i "%confirm2%"=="y" (
    del /F /Q CLEANUP_SUMMARY.md 2>nul
    del /F /Q OPTIMIZATION_SUMMARY.md 2>nul
    del /F /Q PICKUP_DROPOFF_FEATURE.md 2>nul
    del /F /Q PRODUCTION_DEPLOYMENT.md 2>nul
    del /F /Q QUICK_PRODUCTION_GUIDE.md 2>nul
    del /F /Q HTML_DESCRIPTION_GUIDE.md 2>nul
    echo Done: Old documentation removed
)

REM 3. Remove testing files
echo.
echo [3/8] Removing test files...
set /p confirm3="Remove PHPUnit and test files? (y/n): "
if /i "%confirm3%"=="y" (
    rmdir /S /Q tests 2>nul
    del /F /Q phpunit.xml 2>nul
    echo Done: Test files removed
)

REM 4. Clear old logs
echo.
echo [4/8] Clearing old log files...
set /p confirm4="Clear all log files? (y/n): "
if /i "%confirm4%"=="y" (
    del /F /Q storage\logs\*.log 2>nul
    echo Done: Logs cleared
)

REM 5. Remove node_modules
echo.
echo [5/8] Handling node_modules...
set /p confirm5="Remove node_modules? Make sure npm run build was executed first! (y/n): "
if /i "%confirm5%"=="y" (
    rmdir /S /Q node_modules 2>nul
    del /F /Q package-lock.json 2>nul
    echo Done: node_modules removed
)

REM 6. Remove unused TinyMCE
echo.
echo [6/8] Cleaning up TinyMCE...
set /p confirm6="Remove unused TinyMCE plugins to save space? (y/n): "
if /i "%confirm6%"=="y" (
    REM Keep only essential plugins - lists, link, image, table, code, preview
    for /d %%i in (public\vendor\tinymce\plugins\*) do (
        if not "%%~ni"=="lists" if not "%%~ni"=="link" if not "%%~ni"=="image" if not "%%~ni"=="table" if not "%%~ni"=="code" if not "%%~ni"=="preview" (
            rmdir /S /Q "%%i" 2>nul
        )
    )
    echo Done: Unused TinyMCE plugins removed
)

REM 7. Optimize Laravel
echo.
echo [7/8] Optimizing Laravel...
echo Clearing all caches...
php artisan optimize:clear

echo Building optimized caches...
php artisan config:cache
php artisan route:cache
php artisan view:cache
php artisan event:cache

echo Optimizing composer autoloader...
composer dump-autoload --optimize --classmap-authoritative

echo Done: Laravel optimized for production

REM 8. Build frontend assets
echo.
echo [8/8] Building frontend assets...
set /p confirm8="Run npm run build? (y/n): "
if /i "%confirm8%"=="y" (
    call npm run build
    echo Done: Frontend assets built
)

REM Final summary
echo.
echo ======================================
echo Cleanup Complete!
echo ======================================
echo.
echo Production-ready optimizations applied
echo.
echo Next steps:
echo 1. Test the application thoroughly
echo 2. Deploy to production server
echo 3. Monitor logs: storage\logs\laravel.log
echo.
echo For complete optimization guide, see:
echo   PRODUCTION_OPTIMIZATION_COMPLETE.md
echo.

pause
