<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        // Register middleware aliases
        $middleware->alias([
            'admin' => \App\Http\Middleware\IsAdmin::class,
            'host.or.admin' => \App\Http\Middleware\IsHostOrAdmin::class,
        ]);

        // Apply security headers to all web requests
        $middleware->web(append: [
            \App\Http\Middleware\SecurityHeaders::class,
        ]);

        // Exclude webhook endpoints from CSRF verification
        // Webhooks need to be accessible without CSRF tokens
        $middleware->validateCsrfTokens(except: [
            'payment/callback',
            'webhook',
            'webhook/*',
        ]);

        // Rate limiting for API routes (60 requests per minute)
        $middleware->throttleApi();
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })->create();
