<?php

namespace App\Services;

use App\Models\Setting;

class GatewayFeeService
{
    /**
     * Calculate payment gateway fee for a booking amount
     */
    public static function calculateFee(float $bookingAmount): float
    {
        $feeType = Setting::get('payment_gateway_fee_type', 'percentage');
        $fixedFee = floatval(Setting::get('payment_gateway_fee_fixed', 0));
        $percentageFee = floatval(Setting::get('payment_gateway_fee_percentage', 0));

        $fee = 0;

        if ($feeType === 'fixed') {
            $fee = $fixedFee;
        } elseif ($feeType === 'percentage') {
            $fee = ($bookingAmount * $percentageFee) / 100;
        } else { // both
            $fee = $fixedFee + (($bookingAmount * $percentageFee) / 100);
        }

        return round($fee, 2);
    }

    /**
     * Check if gateway fee is configured
     */
    public static function isEnabled(): bool
    {
        $fixedFee = floatval(Setting::get('payment_gateway_fee_fixed', 0));
        $percentageFee = floatval(Setting::get('payment_gateway_fee_percentage', 0));

        return $fixedFee > 0 || $percentageFee > 0;
    }
}
