<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class HelperServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        // Register the SeoHelper class
        $this->app->singleton('seo', function () {
            return new \App\Helpers\SeoHelper();
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Share SEO data with all views
        view()->composer('*', function ($view) {
            $view->with([
                'siteName' => \App\Helpers\SeoHelper::siteName(),
                'siteLogo' => \App\Helpers\SeoHelper::logo(),
            ]);
        });
    }
}
