<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class WebhookLog extends Model
{
    protected $fillable = [
        'source',
        'event_type',
        'webhook_id',
        'url',
        'method',
        'headers',
        'payload',
        'response',
        'status',
        'ip_address',
        'error_message',
        'processed_at',
    ];

    protected $casts = [
        'headers' => 'array',
        'payload' => 'array',
        'response' => 'array',
        'processed_at' => 'datetime',
    ];

    public function scopeBySource($query, $source)
    {
        return $query->where('source', $source);
    }

    public function scopeSuccessful($query)
    {
        return $query->where('status', 'success');
    }

    public function scopeFailed($query)
    {
        return $query->where('status', 'failed');
    }
}
