<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OutgoingWebhookConfig extends Model
{
    protected $fillable = [
        'enabled',
        'webhook_url',
        'payment_success',
        'payment_failed',
        'booking_created',
        'booking_cancelled',
        'secret_key',
    ];

    protected $casts = [
        'enabled' => 'boolean',
        'payment_success' => 'boolean',
        'payment_failed' => 'boolean',
        'booking_created' => 'boolean',
        'booking_cancelled' => 'boolean',
    ];

    /**
     * Get the configuration (singleton pattern)
     */
    public static function getConfig(): self
    {
        return self::firstOrCreate([]);
    }
}
