<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Location extends Model
{
    protected $fillable = ['name', 'slug', 'description', 'image', 'is_popular'];

    protected $casts = [
        'is_popular' => 'boolean',
    ];

    public function listings(): HasMany
    {
        return $this->hasMany(Listing::class);
    }

    public function scopePopular($query)
    {
        return $query->where('is_popular', true);
    }
}
