<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class HostReceipt extends Model
{
    protected $fillable = [
        'booking_id',
        'receipt_number',
        'base_amount',
        'addon_amount',
        'discount_amount',
        'subtotal',
        'platform_fee',
        'service_fee',
        'total_deductions',
        'host_payout',
        'payout_status',
        'payout_date',
        'payout_reference',
        'payout_notes',
    ];

    protected $casts = [
        'base_amount' => 'decimal:2',
        'addon_amount' => 'decimal:2',
        'discount_amount' => 'decimal:2',
        'subtotal' => 'decimal:2',
        'platform_fee' => 'decimal:2',
        'service_fee' => 'decimal:2',
        'total_deductions' => 'decimal:2',
        'host_payout' => 'decimal:2',
        'payout_date' => 'datetime',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($hostReceipt) {
            if (empty($hostReceipt->receipt_number)) {
                // Generate receipt number: HOST-YYYYMMDD-XXXXX
                $hostReceipt->receipt_number = 'HOST-' . date('Ymd') . '-' . str_pad(rand(1, 99999), 5, '0', STR_PAD_LEFT);
            }
        });
    }

    public function booking(): BelongsTo
    {
        return $this->belongsTo(Booking::class);
    }
}
