<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DiscountTier extends Model
{
    protected $fillable = [
        'listing_id',
        'min_days',
        'max_days',
        'discount_type',
        'discount_value',
    ];

    protected $casts = [
        'discount_value' => 'decimal:2',
    ];

    public function listing(): BelongsTo
    {
        return $this->belongsTo(Listing::class);
    }

    /**
     * Calculate discount amount for given total and days
     */
    public function calculateDiscount(float $subtotal, int $days): float
    {
        if ($this->discount_type === 'fixed') {
            return $this->discount_value;
        } else {
            return ($subtotal * $this->discount_value) / 100;
        }
    }

    /**
     * Check if this tier applies to the given number of days
     */
    public function appliesTo(int $days): bool
    {
        $minCondition = $days >= $this->min_days;
        $maxCondition = $this->max_days === null || $days <= $this->max_days;

        return $minCondition && $maxCondition;
    }
}
