<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BadgeConfig extends Model
{
    protected $fillable = [
        'badge_type',
        'name',
        'icon',
        'color',
        'min_reviews',
        'min_rating',
        'time_period_months',
        'is_active',
    ];

    protected $casts = [
        'min_reviews' => 'integer',
        'min_rating' => 'decimal:2',
        'time_period_months' => 'integer',
        'is_active' => 'boolean',
    ];

    public static function getActiveBadges()
    {
        return static::where('is_active', true)
            ->orderBy('min_rating', 'desc')
            ->orderBy('min_reviews', 'desc')
            ->get();
    }
}
