<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Amenity extends Model
{
    protected $fillable = [
        'name',
        'rental_type_id',
        'is_active',
        'sort_order',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function rentalType(): BelongsTo
    {
        return $this->belongsTo(RentalType::class);
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeForRentalType($query, $rentalTypeId)
    {
        return $query->where('rental_type_id', $rentalTypeId);
    }
}
