<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Listing;

class ListingDetails extends Component
{
    use WithPagination;

    public $listingId;
    public $listing;
    public $reviewFilter = 'recent'; // recent, highest, lowest
    public $reviewsPerPage = 5;

    public function mount($id)
    {
        $this->listingId = $id;
        $this->listing = Listing::with(['rentalType', 'location', 'host', 'discountTiers', 'addOns'])
            ->withCount('reviews')
            ->withAvg('reviews', 'rating')
            ->findOrFail($id);
    }

    public function updatedReviewFilter()
    {
        $this->resetPage();
    }

    public function setReviewFilter($filter)
    {
        $this->reviewFilter = $filter;
        $this->resetPage();
    }

    public function getReviewsProperty()
    {
        $query = $this->listing->reviews()->with('user');

        switch ($this->reviewFilter) {
            case 'highest':
                $query->orderBy('rating', 'desc')->orderBy('created_at', 'desc');
                break;
            case 'lowest':
                $query->orderBy('rating', 'asc')->orderBy('created_at', 'desc');
                break;
            case 'recent':
            default:
                $query->orderBy('created_at', 'desc');
                break;
        }

        return $query->paginate($this->reviewsPerPage);
    }

    public function render()
    {
        // Refresh listing with aggregates on each render to ensure values are up to date
        $this->listing = Listing::with(['rentalType', 'location', 'host', 'discountTiers', 'addOns'])
            ->withCount('reviews')
            ->withAvg('reviews', 'rating')
            ->findOrFail($this->listingId);

        return view('livewire.listing-details', [
            'reviews' => $this->reviews
        ])->layout('layouts.app');
    }
}
