<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Location;
use App\Models\RentalType;
use App\Models\Listing;

class Home extends Component
{
    public $location_id = '';
    public $rental_type_id = '';
    public $check_in = '';
    public $check_out = '';
    public $guests = 1;

    public function search()
    {
        $query = http_build_query([
            'location' => $this->location_id,
            'type' => $this->rental_type_id,
            'check_in' => $this->check_in,
            'check_out' => $this->check_out,
            'guests' => $this->guests,
        ]);

        return redirect()->to('/listings?' . $query);
    }

    public function render()
    {
        // Cache locations for 1 hour (3600 seconds)
        $allLocations = \Illuminate\Support\Facades\Cache::remember('locations.all', 3600, function () {
            return Location::withCount('listings')->orderBy('name')->get();
        });

        // Cache rental types for 1 hour
        $rentalTypes = \Illuminate\Support\Facades\Cache::remember('rental_types.all', 3600, function () {
            return RentalType::all();
        });

        // Cache featured listings for 10 minutes (600 seconds) - refresh more often
        $featuredListings = \Illuminate\Support\Facades\Cache::remember('listings.featured', 600, function () {
            return Listing::with(['location', 'rentalType'])
                ->withCount('reviews')
                ->withAvg('reviews', 'rating')
                ->featured()
                ->available()
                ->limit(20) // Show 8-20 featured listings
                ->get();
        });

        return view('livewire.home', [
            'allLocations' => $allLocations,
            'rentalTypes' => $rentalTypes,
            'featuredListings' => $featuredListings,
        ])->layout('layouts.app');
    }
}
