<?php

namespace App\Livewire\Admin;

use App\Models\User;
use Livewire\Component;
use Livewire\WithPagination;

class Users extends Component
{
    use WithPagination;

    public $search = '';
    public $roleFilter = '';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function updatingRoleFilter()
    {
        $this->resetPage();
    }

    public function toggleVerification($userId)
    {
        $user = User::findOrFail($userId);

        if ($user->email_verified_at) {
            $user->update(['email_verified_at' => null]);
            session()->flash('message', 'User email verification removed.');
        } else {
            $user->update(['email_verified_at' => now()]);
            session()->flash('message', 'User email verified successfully.');
        }
    }

    public function changeRole($userId, $newRole)
    {
        $user = User::findOrFail($userId);
        $user->update(['role' => $newRole]);
        session()->flash('message', "User role updated to {$newRole}.");
    }

    public function toggleVacationMode($userId)
    {
        $user = User::findOrFail($userId);

        // Only toggle for hosts
        if (!$user->isHost()) {
            session()->flash('error', 'Vacation mode is only available for hosts.');
            return;
        }

        $user->update(['vacation_mode' => !$user->vacation_mode]);

        $status = $user->vacation_mode ? 'enabled' : 'disabled';
        session()->flash('message', "Vacation mode {$status} for {$user->name}.");
    }

    public function toggleCustomLocations($userId)
    {
        $user = User::findOrFail($userId);

        // Only toggle for hosts
        if (!$user->isHost()) {
            session()->flash('error', 'Custom locations feature is only available for hosts.');
            return;
        }

        $user->update(['can_create_custom_locations' => !$user->can_create_custom_locations]);

        $status = $user->can_create_custom_locations ? 'enabled' : 'disabled';
        session()->flash('message', "Custom pickup locations {$status} for {$user->name}.");
    }

    public function deleteUser($userId)
    {
        $user = User::findOrFail($userId);

        // Prevent deleting yourself
        if ($user->id === auth()->id()) {
            session()->flash('error', 'You cannot delete your own account.');
            return;
        }

        $user->delete();
        session()->flash('message', 'User deleted successfully.');
    }

    public function render()
    {
        $query = User::query();

        if ($this->search) {
            $query->where(function($q) {
                $q->where('name', 'like', '%' . $this->search . '%')
                  ->orWhere('email', 'like', '%' . $this->search . '%')
                  ->orWhere('phone', 'like', '%' . $this->search . '%');
            });
        }

        if ($this->roleFilter) {
            $query->where('role', $this->roleFilter);
        }

        $users = $query->withCount(['listings', 'bookings'])
                       ->latest()
                       ->paginate(15);

        return view('livewire.admin.users', compact('users'))
            ->layout('layouts.app');
    }
}
