<?php

namespace App\Livewire\Admin;

use App\Models\Location;
use Illuminate\Support\Str;
use Livewire\Component;

class Locations extends Component
{
    public $name = '';
    public $description = '';
    public $image = '';
    public $is_popular = false;
    public $editingId = null;

    public function save()
    {
        $this->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'image' => 'nullable|string',
        ]);

        if ($this->editingId) {
            $location = Location::find($this->editingId);
            $location->update([
                'name' => $this->name,
                'slug' => Str::slug($this->name),
                'description' => $this->description,
                'image' => $this->image,
                'is_popular' => $this->is_popular,
            ]);
            session()->flash('message', 'Location updated successfully!');
        } else {
            Location::create([
                'name' => $this->name,
                'slug' => Str::slug($this->name),
                'description' => $this->description,
                'image' => $this->image,
                'is_popular' => $this->is_popular,
            ]);
            session()->flash('message', 'Location created successfully!');
        }

        $this->reset(['name', 'description', 'image', 'is_popular', 'editingId']);
    }

    public function edit($id)
    {
        $location = Location::findOrFail($id);
        $this->editingId = $id;
        $this->name = $location->name;
        $this->description = $location->description;
        $this->image = $location->image;
        $this->is_popular = $location->is_popular;
    }

    public function delete($id)
    {
        Location::findOrFail($id)->delete();
        session()->flash('message', 'Location deleted successfully!');
    }

    public function cancel()
    {
        $this->reset(['name', 'description', 'image', 'is_popular', 'editingId']);
    }

    public function render()
    {
        $locations = Location::withCount('listings')->get();

        return view('livewire.admin.locations', compact('locations'))
            ->layout('layouts.app');
    }
}
