<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use App\Models\AddOn;

class AddOnsManager extends Component
{
    public $addOns;
    public $showModal = false;
    public $editMode = false;

    // Form fields
    public $addOnId;
    public $name;
    public $description;
    public $price;
    public $pricing_type = 'per_booking';
    public $is_active = true;

    protected $rules = [
        'name' => 'required|string|max:255',
        'description' => 'nullable|string',
        'price' => 'required|numeric|min:0',
        'pricing_type' => 'required|in:per_booking,per_day,per_person',
        'is_active' => 'boolean',
    ];

    public function mount()
    {
        $this->loadAddOns();
    }

    public function loadAddOns()
    {
        $this->addOns = AddOn::orderBy('name')->get();
    }

    public function openModal()
    {
        $this->resetForm();
        $this->showModal = true;
    }

    public function closeModal()
    {
        $this->showModal = false;
        $this->resetForm();
    }

    public function resetForm()
    {
        $this->reset(['addOnId', 'name', 'description', 'price', 'pricing_type', 'is_active', 'editMode']);
        $this->pricing_type = 'per_booking';
        $this->is_active = true;
        $this->resetValidation();
    }

    public function edit($id)
    {
        $addOn = AddOn::findOrFail($id);

        $this->addOnId = $addOn->id;
        $this->name = $addOn->name;
        $this->description = $addOn->description;
        $this->price = $addOn->price;
        $this->pricing_type = $addOn->pricing_type;
        $this->is_active = $addOn->is_active;
        $this->editMode = true;
        $this->showModal = true;
    }

    public function save()
    {
        $this->validate();

        if ($this->editMode) {
            $addOn = AddOn::findOrFail($this->addOnId);
            $addOn->update([
                'name' => $this->name,
                'description' => $this->description,
                'price' => $this->price,
                'pricing_type' => $this->pricing_type,
                'is_active' => $this->is_active,
            ]);
            session()->flash('message', 'Add-on updated successfully!');
        } else {
            AddOn::create([
                'name' => $this->name,
                'description' => $this->description,
                'price' => $this->price,
                'pricing_type' => $this->pricing_type,
                'is_active' => $this->is_active,
            ]);
            session()->flash('message', 'Add-on created successfully!');
        }

        $this->closeModal();
        $this->loadAddOns();
    }

    public function toggleStatus($id)
    {
        $addOn = AddOn::findOrFail($id);
        $addOn->update(['is_active' => !$addOn->is_active]);
        $this->loadAddOns();
        session()->flash('message', 'Add-on status updated!');
    }

    public function delete($id)
    {
        $addOn = AddOn::findOrFail($id);
        $addOn->delete();
        $this->loadAddOns();
        session()->flash('message', 'Add-on deleted successfully!');
    }

    public function render()
    {
        return view('livewire.admin.add-ons-manager')->layout('layouts.app');
    }
}
