<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class IsHostOrAdmin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (!auth()->check()) {
            return redirect()->route('login');
        }

        $user = auth()->user();

        // Only allow admin and host roles
        if ($user->isAdmin() || $user->isHost()) {
            return $next($request);
        }

        // Redirect regular users to their bookings page
        return redirect()->route('user.bookings')->with('error', 'You do not have access to this page.');
    }
}
