# GengSewa - Rental Platform

A modern, full-featured rental platform built with Laravel 12 and Livewire 3. Support for cars, houseboats, guesthouses, boats, and more.

## Features

- **Multi-Category Rentals**: Support for various rental types (cars, boats, properties)
- **Location-Based Search**: Browse by location and rental type
- **Secure Payments**: BayarCash payment gateway integration (FPX, Cards, eWallets)
- **Role-Based Access**: Admin, Host, and Guest roles with appropriate permissions
- **Booking Management**: Complete booking workflow with status tracking
- **CSV Export**: Export bookings for record-keeping
- **Professional Receipts**: Beautiful, customizable receipt templates
- **Admin Panel**: Comprehensive settings and management interface
- **Real-Time Components**: Built with Livewire for reactive UI
- **Dark Mode**: Support for light/dark themes
- **Security**: CSRF protection, XSS prevention, SQL injection protection

## Quick Start

```bash
# Clone repository
git clone <repository-url> gengsewa
cd gengsewa

# Install dependencies
composer install
npm install

# Setup environment
cp .env.example .env
php artisan key:generate

# Configure database in .env, then migrate
php artisan migrate --seed

# Create storage link
php artisan storage:link

# Build assets and start server
npm run build
php artisan serve
```

Visit **http://localhost:8000**

## Complete Documentation

**📖 See [SETUP.md](SETUP.md) for complete installation, configuration, and deployment guide.**

The SETUP.md file includes:
- System requirements
- Installation steps
- Payment gateway setup (BayarCash)
- Security configuration
- Production deployment checklist
- Troubleshooting guide

## Tech Stack

- **Backend**: Laravel 12, PHP 8.2+
- **Frontend**: Livewire 3, Alpine.js, Tailwind CSS
- **Database**: MySQL 8.0+ or MariaDB 10.3+
- **Payment**: BayarCash Payment Gateway
- **Assets**: Vite

## Composer Packages

Core dependencies:
- `laravel/framework` - Laravel framework
- `livewire/livewire` - Full-stack framework for Laravel
- `webimpian/bayarcash-php-sdk` - Payment gateway integration
- `aws/aws-sdk-php` - AWS services (optional for S3, SES)

## Directory Structure

```
gengsewa/
├── app/
│   ├── Http/
│   │   ├── Controllers/     # Controllers
│   │   └── Middleware/      # Custom middleware
│   ├── Livewire/            # Livewire components
│   │   ├── Admin/           # Admin panel components
│   │   └── Host/            # Host management components
│   ├── Models/              # Eloquent models
│   └── Helpers/             # Helper classes
├── database/
│   ├── migrations/          # Database migrations
│   └── seeders/             # Database seeders
├── public/
│   └── images/              # Image storage (.gitkeep preserved)
├── resources/
│   ├── css/                 # Tailwind CSS
│   ├── js/                  # JavaScript assets
│   └── views/               # Blade templates
├── routes/
│   └── web.php              # Web routes
└── .env.example             # Environment configuration template
```

## Image Directories

All image directories include `.gitkeep` files to preserve folder structure:
- `public/images/flags/` - Country flags
- `public/images/logos/` - Site logos
- `public/images/listings/` - Listing images
- `public/images/favicon/` - Favicons
- `public/images/og-images/` - Social media preview images

## Security

- ✅ CSRF protection enabled by default
- ✅ XSS prevention with Blade escaping
- ✅ SQL injection protection with Eloquent ORM
- ✅ Security headers middleware
- ✅ Rate limiting on API routes
- ✅ Input validation on all forms
- ✅ Password hashing with bcrypt

## Admin Panel

Access the admin panel at `/admin` after setting user role to 'admin':

```sql
UPDATE users SET role = 'admin' WHERE email = 'your@email.com';
```

**Features:**
- Dashboard with analytics
- Manage rental types and locations
- User management
- Booking management with CSV export
- System settings (payment, SEO, branding)
- Receipt template customization

## License

This project is proprietary software. All rights reserved.

## Support

For setup assistance or technical questions, please refer to [SETUP.md](SETUP.md) or contact your development team.

---

**© 2025 GengSewa. All rights reserved.**
